///////////////////////////////////////////////////////////////////////////
//
// irt1dconst.cc fits a constant irt model to the court data 1953-1999
//
/////////////////////////////////////////////////////////////////////////// 
// 
// Kevin Quinn
// Dept. of Political Science and CSSS
// University of Washington
// Seattle, Washington
// quinn@stat.washington.edu
//
// Andrew D. Martin
// Department of Political Science
// Washington University
// St. Louis, Missouri
// admartin@artsci.wustl.edu
//
///////////////////////////////////////////////////////////////////////////
//
// This program is another Quinn Martin production. Copyright (C) 2001.
//
/////////////////////////////////////////////////////////////////////////// 
//
// INPUT FILES:
//
//   bigdata.txt K_total x J_total matrix of votes (9 missing value)
//
// UPDATED: 6/9/2001 (KMQ)
//
/////////////////////////////////////////////////////////////////////////// 

//#include "/home/kq/judic_data/Double_Matrix.h"
//#include "/home/quinn/judic_long/models.h"
//#include <string>
#include <iostream.h>
#include "/home/kq/Scythe0.2/Scythe_Double_Matrix.h"
#include "/home/kq/Scythe0.2/Scythe_Simulate.h" 
#include "/home/kq/Scythe0.2/Scythe_Optimize.h"

using namespace SCYTHE;

// convert integers to strings
//#include <stdio.h>
//string itostring( long int i ) {
//       char buffer[20];
//       sprintf( buffer, "%ld", i );
//       return string( buffer );
//  }





int main() {


   //
   // Global Parameters
   //
   int J = 29;   // total number of justices
   int K = 3450; // total number of cases
   int D = 1;    // dimensionality of the issue space

  // MCMC parameters
  int burnin = 5000;
  int gibbs  = 200000; 
  int thin = 50;
  int tot_iter = burnin + gibbs;  
  
  // prior on \eta_j
  // \eta_j' = (\alpha_j \beta_j') ~ N(b0, B0^-1)
  Matrix b0 = Matrix(D+1,1);
  Matrix B0 = eye(D+1); // precision Matrix (NOT covariance)
  Matrix B0b0 = B0*b0; 
 
  // prior on \theta_i -- note all have some prior
  // \theta_i' ~ N(t0, T0^-1)
  Matrix t0 = Matrix(D,1);
  Matrix T0 = eye(D);  // precision Matrix (NOT covariance)
  Matrix T0t0 = T0*t0;

  // load Matrix Y
  Matrix Y = read_into_matrix("/home/kq/pafinal/new_data/no_unan/vote/bigdata.txt",K,J);
  Y = t(Y);
  





  ///////////////////////////////
  // Initialization of Sampler //
  ///////////////////////////////
  
  // storage matrices (row major order)
  //Matrix eta_store   = Matrix(gibbs,K*(D+1));
  Matrix theta_store = Matrix(gibbs/thin,J*D);
  Matrix median_store = Matrix(J,1);
  Matrix avg_correct = Matrix(J,K);
  //Matrix Zpred = Matrix(J,K);

  // starting values 
  Matrix Z     = Matrix(J,K);
  Matrix theta = rnorm(J,D);
  theta[2] = -3; // put Douglas on the left to start
  theta[4] = -2; // put Marshall on the right to start
  theta[23] = 3; // put Scalia on the right to start

  Matrix eta   = rnorm(K,D+1);  
  Matrix alpha = rnorm(K,1);
  Matrix beta = rnorm(K,1); 




  /*
  // make monte carlo data
   theta = seqa(0,.25,J) - 3.5;
   theta.print();
   alpha = rnorm(K,1,1,1);
   beta = rnorm(K,1,.5,1);
   for (int j=0; j<J; ++j){
     for (int k=0; k<K; ++k){
       Z(j,k) = rnorm(alpha[k] + beta[k]*theta[j], 1.0);
     }
   }
   Y = Matrix(J,K);
   Y = Z>>0.0;
   for (int j=0; j<J; ++j){
     for (int k=0; k<K; ++k){
       if (runif()>.6)
 	Y(j,k) = 9;
     }
   }
  //t(Y(3,seqa(0,1,J))).print();
  //return 1;

   theta = rnorm(J,1);
   theta[20] = 2;
  */




  ///////////////////
  // Gibbs Sampler //
  ///////////////////
  int count = 0;  
  for (int iter=0; iter < tot_iter; ++iter){
    
    // sample Z
    for (int j=0; j<J; ++j){
      for (int k=0; k<K; ++k){
	double Z_mean = alpha[k] + beta[k]*theta[j];
	if (Y(j,k) == 1.0)
	  Z(j,k) = rtbnorm_combo(Z_mean, 1.0, 0);
	if(isinf(Z(j,k)))
	  Z(j,k) = 0;
	if (Y(j,k) == 0.0)
	  Z(j,k) = rtanorm_combo(Z_mean, 1.0, 0);
	if(isinf(Z(j,k)))
	  Z(j,k) = 0;
	if (Y(j,k) != 1.0 && Y(j,k) != 0.0)
	  Z(j,k) = rnorm(Z_mean, 1.0);
      }
    }

    
    // sample eta
    Matrix theta_star = cbind(ones(J,1),theta);
    Matrix post_var = invpd(crossprod(theta_star) + B0);
    Matrix Cpost_var = cholesky(post_var);
    for (int k=0; k<K; ++k){
      Matrix post_mean = post_var * gaxpy(t(theta_star), 
					  Z(_,k), B0b0);
      Matrix new_eta =  gaxpy(Cpost_var,  rnorm(D+1,1), post_mean);
      alpha[k] = new_eta[0]; // needs to be changed is D>1 
      beta[k] = new_eta[1];  // needs to be changed is D>1
      //for(int d = 0; d<D+1; ++d)
      //	eta(k,d) = new_eta[d];
    }
    
    
    // sample theta
    //Matrix alpha = eta(seqa(0,1,K),0);
    //Matrix beta = eta(seqa(0,1,K),1);
    //for (int j = 2; j < D+1; ++j) {
    //  Matrix beta_hold = eta(seqa(0,1,K), j);
    //  beta = cbind(beta, beta_hold);
    //}
    post_var = 1/(crossprod(beta) + T0);
    Cpost_var = sqrt(post_var);
    for (int j=0; j<J; ++j){
      Matrix new_theta;
      Matrix post_mean = post_var*gaxpy(t(beta), 
					t(Z(j,_))-alpha, T0t0);
      new_theta = t(gaxpy(Cpost_var,  rnorm(D,1), post_mean));
      /*
	if (j==0){ // Harlan active and > 0
	  new_theta[0] = rtbnorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = 3*ones(1,1);
	}
	if (j==2){ // Douglas active and < 0
	  new_theta[0] = rtanorm_combo(post_mean[0], post_var[0], 0);
	  if (iter < 20) new_theta = -3*ones(1,1);
	}
  	if (j==4){ // Marshall active and < 0
	  new_theta[0] = rtanorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = -2*ones(1,1);
	}
  	if (j==5){ // Brennan active and < 0
	  new_theta[0] = rtanorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = -2*ones(1,1);
	}
	if (j==9){ // Franklin active and > 0
	  new_theta[0] = rtbnorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = 3*ones(1,1);
	}	
  	if (j==13){ // Fortas active and < 0
	  new_theta[0] = rtanorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = -2*ones(1,1);
	}	
	if (j==20){ // Rehnquist active and > 0
	  new_theta[0] = rtbnorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = 3*ones(1,1);
	}
	if (j==23){ // Scalia active and > 0
	  new_theta[0] = rtbnorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = 3*ones(1,1);
	}
	if (j==26){ // Thomas active and > 0
	  new_theta[0] = rtbnorm_combo(post_mean[0], post_var[0], 0);	 
	  if (iter < 20) new_theta = 3*ones(1,1);
	}
      */

      for(int l = 0; l<D; l++)
	theta(j,l) = new_theta(0,l);
    }

    if (theta[2] > 0 ) // flip if Douglas on the right
      theta = -1*theta;


    // if after burn-in compute predicted values and save
    Matrix ypredhold;
    if (iter >= burnin){
      ypredhold = Matrix(J,K);
      for (int j=0; j<J; ++j){
	for (int k=0; k<K; ++k){   
	  double Z_mean = alpha[k] + beta[k]*theta[j];       
	  double Zpred = rnorm(Z_mean, 1.0);
	  ypredhold(j,k) = (Zpred>0);
	}
      }
    }    

    // initialize for first iteration
    if (iter==burnin){
       avg_correct = (ypredhold^=Y);
    }
    if (iter > burnin){
      Matrix avg_correct_t = (ypredhold^=Y);
      double itcount = static_cast<double>(iter-burnin);
      avg_correct = (1.0/(1.0+itcount))* 
	(itcount*avg_correct + avg_correct_t);
    }
    

    
    // print results to screen
    if ( (iter % 50) == 0){
      cout << "Gibbs Iteration = " << iter << endl;
      t(theta).print();      
    }

    // store results
    if ((iter >= burnin) && ((iter%thin)==0)){
      //Matrix eta_store_vec = reshape(eta,1,K*(D+1)); 
       Matrix theta_store_vec = reshape(theta,1,J*D);
       //for (int l=0; l<K*(D+1); ++l)
       //     eta_store((iter-burnin), l) = eta_store_vec(0,l);
       for (int l=0; l<J*D; ++l)
	      theta_store(count, l) = theta_store_vec(0,l);
       ++count;
        // compute median justice (for posterior predictive density)
       //        theta_store_vec = t(theta_store_vec);
       // Matrix theta_sorted = bubble_sort(theta_store_vec);
       // double median = theta_sorted(4,0);
       // int median_justice = 0;
       // for(int i=0; i<N; ++i) {
       //   if (median == theta_store_vec(i,0)) median_justice = i;
       //   }
       // median_store(median_justice,0) = median_store(median_justice,0) + 1;
        }
        
    } // end Gibbs loop
  
  // average over median 
  //median_store = pow(gibbs,-1) * median_store;

  ////////////////////////
  // Write Output Files //
  ////////////////////////
   
  Matrix theta_out = cbind(t(meanc(theta_store)),t(stdc(theta_store)));
  
  cout << endl;
  cout << "@@@@@@@@@@@@@@@@@@@@@@@" << endl;
  cout << "Theta Posterior Summary" << endl;
  cout << "@@@@@@@@@@@@@@@@@@@@@@@" << endl;
  cout << endl;
  cout << "  PostMean PostStdDev" << endl;
  theta_out.print();

  //cout << "Median Justice Posterior Probabilities" << endl;
  //median_store.print();

  cout << "avg. correct" << endl;
  meanc(t(avg_correct)).print();

  // write_Matrix_out (eta_store, "eta.txt", "o", false);
  write_matrix_out (theta_store, "theta.txt", "o", false);
  write_matrix_out(t(avg_correct), "avgcorrect.txt", "o", false);

} // end main()














